({
    extendsFrom: "RecordlistView",

    events: {
        'click [class*="orderBy"]':'setOrderBy'
    },

    initialize: function (options) {

        this.contextEvents = _.extend({}, this.contextEvents, {
            "list:download_flowchart:fire": "downloadFlowchartSourceFile",
            "list:enabledisable:fire": "warnActivateDeactivate",
            "list:deactivate:fire": "warnMassDeactivate",
            "list:activate:fire": "warnMassActivate"
        });

        this._super("initialize", [options]);

        this.collection.reset([]);
    },

    sort: function() {
        this._super("sort");
        this.loadData();
    },

    loadData: function (options) {
        app.alert.show('load_lb_packages_list', {
            level: 'process',
            title: app.lang.get('LBL_LOADING'),
            autoClose: false
        });

        app.api.call('read', app.api.buildURL('logicBuilder', 'packages', {}, {
            orderBy: this.collection.orderBy || {}
        }), {}, {
            success: _.bind(function (data) {
                this.collection.dataFetched = true;
                this.collection.next_offset = -1;
                this.collection.reset(this.refreshLBPackageCollection(data));

            }, this),
            error: _.bind(function (error) {
                app.alert.show("load_lb_packages_list_error", {
                    level: "error",
                    messages: app.lang.get('ERR_LOAD_LB_PACKAGES_LIST').replace('%ERROR_MSG%', error.message)
                });
            }, this),
            complete: function(data){
                app.alert.dismiss("load_lb_packages_list");
            }
        });
    },

    _setOrderBy: function (options) {
        if(this.orderByLastStateKey) {
            app.user.lastState.set(this.orderByLastStateKey, this.orderBy);
        }
        this.loadData();
    },

    refreshLBPackageCollection: function(data){
        var models = [];
        if(_.isEmpty(data) || !_.has(data, 'records') || !_.isObject(data.records))
            return models;

        _.each(data.records, function(row){
            models.push(this.getLBPackageModel(row));
        }, this);

        return models;
    },

    getLBPackageModel: function(row){
        var model = new app.data.beanModel();
        _.each(row, function(value, name) {
            model.set(name, value);
        }, this);
        return model;
    },

    downloadFlowchartSourceFile: function(model, field){

        var package_id = field.model.get('id'),
            url;

        if(_.isEmpty(package_id)){
            app.alert.show("download_flowchart_source_error", {
                level: "error",
                messages: app.lang.get('ERR_DOWNLOAD_FLOWCHART_SOURCE', 'Administration'),
                autoClose: true,
                autoCloseDelay: 8000
            });
        }

        url = app.api.buildURL('logicBuilder/package/downloadFlowchart', '', {}, {
            force_download: 1,
            platform: 'base',
            package_id: package_id
        });

        app.api.fileDownload(url, {
            success: function(data){
            },
            error: function(data) {
                app.alert.show("download_flowchart_source_file_missing_error", {
                    level: "error",
                    messages: app.lang.get('ERR_DOWNLOAD_FLOWCHART_SOURCE_FILE_MISSING', 'Administration'),
                });
            },
            complete: function(data){
                app.alert.dismiss("download_flowchart_source");
            }
        }, {iframe: field.$el});

        app.alert.show('download_flowchart_source', {
            level: 'process',
            title: app.lang.get('LBL_LOADING'),
            autoClose: false
        });
    },

    _render: function() {
        this._super('_render');

        var self = this;

        this.collection.each(function(model) {
            var moduleName = model['module'] || '',
                modelId = model.get('id'),
                row = self.$el.find('tr[name=' + moduleName + '_' + modelId + ']'),
                downloadFlowchartButton, activateFlowchartRowButton, deactivateFlowchartRowButton,
                isLoadableFlowchartSource = !!model.get('is_loadable_flowchart_source');

            if(!_.isEmpty(row)) {
                if(!isLoadableFlowchartSource) {
                    downloadFlowchartButton = row.find('.rowaction[data-event="list:download_flowchart:fire"]');
                    if (!_.isEmpty(downloadFlowchartButton)) {
                        downloadFlowchartButton.addClass('disabled')
                    }
                }
            }

        });

    },

    warnMassDeactivate: function(){
        var self = this,
            massModel = this.context.get('mass_collection');

        app.alert.show('deactivate_confirmation', {
            level: 'confirmation',
            messages:  app.lang.get('NTC_DEACTIVATE_FLOWCHARTS', 'Administration').replace('%FLOWCHARTS_COUNT%', massModel.length),
            onConfirm: _.bind(this.deactivateModels, this, massModel.models),
            onCancel: function() {
            }
        });
    },

    warnDeactivate: function(model) {
        app.alert.show('deactivate_confirmation', {
            level: 'confirmation',
            messages:  app.lang.get('NTC_DEACTIVATE_FLOWCHART', 'Administration').replace('%FLOWCHART_NAME%', model.get('flowchart_name')),
            onConfirm: _.bind(this.deactivateModel, this, model),
            onCancel: function() {
            }
        });
    },

    deactivateModel: function(model){
        var models = [model];
        this.deactivateModels(models);
    },

    deactivateModels: function(models){

        app.api.call('create', app.api.buildURL('logicBuilder', 'packages/deactivate', {}, {
            package_ids: _.map(models, function(model){ return model.get('id'); })
        }), {}, {
            success: _.bind(function (data) {
               this.updatePackageStatus(models, data);
            }, this),
            error: _.bind(function (error) {
                app.alert.show("deactivate_error", {
                    level: "error",
                    messages: error.message
                });
            }, this)
        });

    },

    updatePackageStatus: function(models, response){
        var changedIds = response['changed_ids'] || [],
            newStatus = response['package_status'] || '',
            unchangedModels = [];

        if(!_.isEmpty(newStatus)) {
            _.each(models, function(model){
               var wasChanged = _.find(changedIds, function(id){ return model.get('id') == id; })
                if(!_.isUndefined(wasChanged)){
                    model.set('package_status', newStatus);
                }else{
                    unchangedModels.push(model);
                }
            });

            if(unchangedModels.length){
                app.alert.show('change_status_warning', {
                    level: 'warning',
                    messages: app.lang.get('NTC_NO_DEACTIVATION_SUPPORT').replace('%COUNT%', unchangedModels.length),
                    autoClose: true,
                    autoCloseDelay: 8000
                });
            }
        }

    },

    warnActivateDeactivate: function(model){
        if(model.get('package_status') == 'enabled'){
            this.warnDeactivate(model);
        }else{
            this.warnActivate(model);
        }
    },

    warnMassActivate: function(){
        var self = this,
            massModel = this.context.get('mass_collection');

        app.alert.show('activate_confirmation', {
            level: 'confirmation',
            messages:  app.lang.get('NTC_ACTIVATE_FLOWCHARTS', 'Administration').replace('%FLOWCHARTS_COUNT%', massModel.length),
            onConfirm: _.bind(this.activateModels, this, massModel.models),
            onCancel: function() {
            }
        });
    },

    warnActivate: function(model) {
        app.alert.show('activate_confirmation', {
            level: 'confirmation',
            messages:  app.lang.get('NTC_ACTIVATE_FLOWCHART', 'Administration').replace('%FLOWCHART_NAME%', model.get('flowchart_name')),
            onConfirm: _.bind(this.activateModel, this, model),
            onCancel: function() {
            }
        });
    },

    activateModel: function(model){
        var models = [model];
        this.activateModels(models);
    },

    activateModels: function(models){

        app.api.call('create', app.api.buildURL('logicBuilder', 'packages/activate', {}, {
            package_ids: _.map(models, function(model){ return model.get('id'); })
        }), {}, {
            success: _.bind(function (data) {
                this.updatePackageStatus(models, data);
            }, this),
            error: _.bind(function (error) {
                app.alert.show("activate_error", {
                    level: "error",
                    messages: error.message
                });
            }, this)
        });

    },

})
