({
    extendsFrom: 'RowactionField',

    minFlowchartVersionCompatibleWithDownload: 1,

    initialize: function (options) {
        this._super("initialize", [options]);
        this.type = 'rowaction';
    },

    _render: function () {

        if(!this.isFlowchartVersionCompatibleWithDownload()) {
            this.setDisabled(true);
        }

        this._super("_render");
    },

    isFlowchartVersionCompatibleWithDownload: function(){
        var currentVersion = this.model.get('flowchart_version') || 0,
            currentVersionFloat = parseFloat(currentVersion);

        if(currentVersionFloat !== NaN){
            return currentVersionFloat >= this.minFlowchartVersionCompatibleWithDownload;
        }
        return false;
    },

    bindDataChange: function () {
        if (this.model) {
            this.model.on("change", this.render, this);
        }
    }

})
