<?php

if(empty($lb_admin_option_defs)) {
    $lb_admin_option_defs = array();
}

SugarAutoLoader::requireWithCustom('ModuleInstall/ModuleInstaller.php');
$moduleInstallerClass = SugarAutoLoader::customClass('ModuleInstaller');

if ($moduleInstallerClass == 'CustomModuleInstaller' && class_exists($moduleInstallerClass)) {
    $sidecarConfig = CustomModuleInstaller::getBaseConfig();
} else {
    $sidecarConfig = ModuleInstaller::getBaseConfig();
}
if (!empty($sidecarConfig['serverUrl'])) {
    $restVersion = trim(trim($sidecarConfig['serverUrl']), '/');
} else {
    $restVersion = 'rest/v11_23';
}

$lb_admin_option_defs['Administration']['metadata'] = array(
    'LBMetadataExport',
    'LBL_LB_EXPORT_META',
    'LBL_LB_EXPORT_META_DESCRIPTION',
    $restVersion. '/logicBuilder/metadata?force_download=1&platform=base'
);

$lb_admin_option_defs['Administration']['lb-package-handler'] = array(
    'Administration',
    'LBL_LB_PACKAGE_MANAGEMENT',
    'LBL_LB_PACKAGE_MANAGEMENT_DESCRIPTION',
    'javascript:parent.SUGAR.App.router.navigate("PxLogicBuilder/package/management", {trigger: true});',
);

$admin_group_header[] = array(
    'LBL_LB_SECTION_HEADER',
    '',
    false,
    $lb_admin_option_defs,
    'LBL_LB_SECTION_DESCRIPTION'
);